## Drag And Drop

In devflow, we can use drag and drop for two special component: ```mui.FlexBox``` and ```mui.JsonLikeTree```. In this tutorial, we will learn how to use drag and drop with ```mui.FlexBox``` in devflow.


### Architecture

there is two dnd events in devflow: ```DragCollect``` and ```Drop```.

- ```DragCollect```: this event is triggered when dropped. The event handler should return data to be dropped.

- ```Drop```: this event is triggered when dropped. The event handler should accept data to be dropped. the data passed to this handler is exactly same as the data returned by ```DragCollect``` handler.

we need to set components that need to be dragged first, then write ```DragCollect``` handler for src component, ```Drop``` handler for dst component.

### Basic Usage

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        text_field = mui.Input("Drag Content", init="Modify This!")
        text = mui.Typography("")
        # you need to specify both draggable and dragType for a 
        # draggable box. dragType is used to identify the type of
        # drag data. you can only drag to a drop box which allows 
        # the dragType.
        drag_box = mui.FlexBox([
            mui.Typography("Drag Me!"),
        ]).prop(flex=1, draggable=True, dragType="JustAType")
        drag_box.event_drag_collect.on(lambda drag_meta_data: text_field.str())
        # you need to specify both droppable and allowedDndTypes for a 
        # droppable box. to get visual feedback, you can specify sxOverDrop.
        drop_box = mui.FlexBox([
            mui.Typography("Drop Here!"),
        ]).prop(flex=1, 
                droppable=True, 
                border="1px solid white",
                sxOverDrop={"border": "1px solid green"},
                allowedDndTypes=["JustAType"])
        drop_box.event_drop.on(lambda drag_collect_data: text.write(drag_collect_data))
        return mui.VBox([
            text_field,
            mui.HBox([
                drag_box,
                drop_box,
            ]),
            text,
        ]).prop(flex=1)

```

### Drag Handle 

**WARNING**: there is a known bug that drag preview is not working.

we can use a drag handle for a draggable component. the drag handle is a component that can be dragged. the drag handle is usually a small component that is easy to drag.

In devflow, we firstly use ```dragInChild=True``` in draggable box, then use ```takeDragRef=True``` in drag handle (must be child box). the ```takeDragRef=True``` will make the drag handle to be the drag handle of the draggable box.

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout
class App:
    @mark_create_layout
    def my_layout(self):
        text_field = mui.Input("Drag Content", init="Modify This!")
        text = mui.Typography("")
        # you need to specify both draggable and dragType for a 
        # draggable box. dragType is used to identify the type of
        # drag data. you can only drag to a drop box which allows 
        # the dragType.
        drag_box = mui.HBox([
            mui.FlexBox([
                mui.Icon(mui.IconType.DragIndicator),
            ]).prop(takeDragRef=True, cursor="move"),
            mui.Typography("Drag Me!"),
        ]).prop(flex=1, draggable=True, dragInChild=True, dragType="JustAType")
        drag_box.event_drag_collect.on(lambda drag_meta_data: text_field.str())
        # you need to specify both droppable and allowedDndTypes for a 
        # droppable box. to get visual feedback, you can specify sxOverDrop.
        drop_box = mui.FlexBox([
            mui.Typography("Drop Here!"),
        ]).prop(flex=1, 
                droppable=True, 
                border="1px solid white",
                sxOverDrop={"border": "1px solid green"},
                allowedDndTypes=["JustAType"])
        drop_box.event_drop.on(lambda drag_collect_data: text.write(drag_collect_data))
        return mui.VBox([
            text_field,
            mui.HBox([
                drag_box,
                drop_box,
            ]),
            text,
        ]).prop(flex=1)


```